local AlphabetWheels = {}
---------------------------------------------------------------------------
-- 
-- If you want classic Wordle functionality, Where there is only 1 Word of the day across the board
-- disable both DiffWordsPerSide and DiffWordsPerProfile

-- If DiffWordsPerSide is disabled, then both active players will receive the same word
-- Even if differentWordsPerProfile is enabled. (Next players will still get diff word)


-- The following shows various scenarios with different values for the above options
-- These sets are played in succession by the players defined below. 
-- Each of these sets are played during the same day
-- No matter what options are set, you won't receive the same word two days in a row* (Well there's a 1/~6000 chance this happens)

-- Set 1 | Player 1 = PAUL, Player 2 = DBK7
-- Set 2 | Player 1 = RUTH, Player 2 = JIMB
-- Set 3 | Player 1 = PAUL, Player 2 = RUTH
-----------------------------------------------
-- If DiffWordSide and DiffPerProfile then

-- Set 1 | P1word = APPLE,  P2word = JACKS
-- Set 2 | P1word = BREAD,  P2word = AUDIO
-- Set 3 | P1word = APPLE,  P2word = ROBOT
-----------------------------------------------

-- If not DiffWordSide and DiffPerProfile then

-- Set 1 | P1word = APPLE,  P2word = APPLE
-- Set 2 | P1word = BREAD,  P2word = BREAD
-- Set 3 | P1word = APPLE,  P2word = BREAD
-----------------------------------------------

-- If DiffWordSide and not DiffPerProfile then

-- Set 1 | P1word = APPLE,  P2word = BREAD
-- Set 2 | P1word = APPLE,  P2word = BREAD
-- Set 3 | P1word = APPLE,  P2word = BREAD
-----------------------------------------------

-- If not DiffWordSide and not DiffPerProfile then

-- Set 1 | P1word = APPLE,  P2word = APPLE
-- Set 2 | P1word = APPLE,  P2word = APPLE
-- Set 3 | P1word = APPLE,  P2word = APPLE
-------------------------------------------------------------------------------------------------

-- Does each specific player (checked profile) receive a different word?
DifferentWordsPerProfile = true
-- Do P1 and P2 receive different words?
DifferentWordsPerSide = true

-- Only effects Expert mode (This is for babies)
RevealWordAtEnd = false
-- The number of words the player and guess
-- I wouldn't go over 6 otherwise things will overlap
local WordleChances = 5

-- The length of each word in letters
-- The current Dictionary only contains 5 letter words, the UI was also made for 5 letter words
local WordleLetters = 5

-- The duration (in seconds) before finishing the game
-- (Don't go longer than this or you will fail the chart because of the arrows at end)
-- Don't worry, the 'hurry up' warning still accounts for adjusted times.
local WordleDuration = 180

---------------------------------------------------------------------------
--OK don't change stuff below here
---------------------------------------------------------------------------
local appleSauce = ""
local year = Year()
local month = MonthOfYear()+1
local day = DayOfMonth()
local date = day.."/"..month .. "/"..year
local function duringRIGHTS()
    if month == 1 and (day > 13 and day < 16) and year == 2023 then
        return true
    end
    return false
end
local Players = GAMESTATE:GetHumanPlayers()
local wordleGame = {
    P1 = {
        name = "GUEST",
        Letter = 1,
        Line = 1,
        EnteringWord = true,
        currentWord = "",
        guesses = {},
        lastEnteredLetter = "",
        word = "APPLE",
        SelectedCharacters = {},
        solved = false,
        ExpertMode = true
    },
    P2 = {
        name = "GUEST",
        Letter = 1,
        Line = 1,
        EnteringWord = true,
        currentWord = "",
        guesses = {},
        lastEnteredLetter = "",
        word = "APPLE",
        SelectedCharacters = {},
        solved = false,
        ExpertMode = true
    },

    -- If diff word per side is disabled, both players will receive the same word of the day
    -- However, the next set of players will get a different word.
    DiffWordPerProfile = DifferentWordsPerProfile,
    revealWord = (RevealWordAtEnd or duringRIGHTS()),
    -- Do P1 and P2 receive different words?
    DiffWordPerSide = DifferentWordsPerSide,
    Letters = WordleLetters,
    Chances = WordleChances,
    duration = WordleDuration,
    dictionary = "dictionary.txt",
    todaysPlayers = "todaysPlayers.txt",
    wordList = {},
    gameInProgress = true
}
local P1, P2
local d1, d2
local newDay = false
local P1xpos, P2xpos
local P1ypos, P2ypos
local enteredLetter = ""
local dataPath = GAMESTATE:GetCurrentSong():GetSongDir().."/data/"

CharacterColors = {
    AlphabetWheel_P1 = {
        A = Color.White,
        B = Color.White,
        C= Color.White,
        D= Color.White,
        E= Color.White,
        F= Color.White,
        G= Color.White,
        H= Color.White,
        I= Color.White,
        J= Color.White,
        K= Color.White,
        L= Color.White,
        M= Color.White,
        N= Color.White,
        O= Color.White,
        P= Color.White,
        Q= Color.White,
        R= Color.White,
        S= Color.White,
        T= Color.White,
        U= Color.White,
        V= Color.White,
        W= Color.White,
        X= Color.White,
        Y= Color.White,
        Z= Color.White
    },
    AlphabetWheel_P2 = {
        A = Color.White,
        B = Color.White,
        C= Color.White,
        D= Color.White,
        E= Color.White,
        F= Color.White,
        G= Color.White,
        H= Color.White,
        I= Color.White,
        J= Color.White,
        K= Color.White,
        L= Color.White,
        M= Color.White,
        N= Color.White,
        O= Color.White,
        P= Color.White,
        Q= Color.White,
        R= Color.White,
        S= Color.White,
        T= Color.White,
        U= Color.White,
        V= Color.White,
        W= Color.White,
        X= Color.White,
        Y= Color.White,
        Z= Color.White
    }

}

---------------------------------------------------------------------------
LoadActor("./Consensual-sick_wheel.lua")

for player in ivalues(Players) do
	if wordleGame[ToEnumShortString(player)].EnteringWord then
		-- Add one AlphabetWheel per human player
		AlphabetWheels[ToEnumShortString(player)] = setmetatable({}, local_sick_wheel_mt)
	end
    wordleGame[ToEnumShortString(player)].ExpertMode = GAMESTATE:GetCurrentSteps(player):GetDifficulty() == "Difficulty_Challenge";
end
---------------------------------------------------------------------------
-- Add the reusable metatable for a generic alphabet character
local alphabet_character_mt = LoadActor("./AlphabetCharacterMT.lua")

---------------------------------------------------------------------------
-- Alphanumeric Characters available to our players for highscore name use
local PossibleCharacters = {
	"&BACK;", "&OK;",
	"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
	"N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"
}
local wordList = {}
function generateWordList()
    if FILEMAN:DoesFileExist(dataPath..wordleGame.dictionary) then
        local words = lua.ReadFile(dataPath..wordleGame.dictionary)
        if words:len() > 2 then
            for line in words:gmatch("[^\r\n]+") do
                wordleGame.wordList[#wordleGame.wordList+1] = line:upper()
            end
            return true
        else
            return false
        end
    end
end
-- Gets new word for the specified player
function getWordOfTheDay()
    if #wordleGame.wordList > 2 then
        local wordIndex = math.random(0,#wordleGame.wordList)
        return wordleGame.wordList[wordIndex]
    end
    return "APPLE"
end
function playedToday(name)
    if FILEMAN:DoesFileExist(dataPath..wordleGame.todaysPlayers) then
        local todaysPlayers = lua.ReadFile(dataPath..wordleGame.todaysPlayers)
        if todaysPlayers:len() > 0 then
            for line in todaysPlayers:gmatch("[^\r\n]+") do
                if name == line then
                    return true
                end
            end
        end
    end
    return false
end

function readData(path)
    local data = {
        universalWord = "APPLE",
        P1 = {
            Guest = {
                word = "APPLE"
            }
        },
        P2 = {
            Guest = {
                word = "APPLE"
            }
        }
    }
    if FILEMAN:DoesFileExist(path) then
        local dataFile = lua.ReadFile(path)
        if dataFile:len() > 3 then
            for line in dataFile:gmatch("[^\r\n]+") do
                if line:find("-") then
                    local jugador = split("-",line)
                    local nombre = split("=",jugador[2])
                    if not data[jugador[1]] then data[jugador[1]] = {} end
                    if not data[jugador[1]][nombre[1]] then data[jugador[1]][nombre[1]] = {} end
                    data[jugador[1]][nombre[1]].word = nombre[2]
                elseif line:find("=") then
                    data.universalWord = split("=",line)[2]
                elseif line:find("/") then
                    data.date = line
                end
            end
        end
    end
    return data
end
function SaveData(data) 
    local file= RageFileUtil.CreateRageFile()
    local strToWrite = wordleGame.date.."\n"..("UniversalWord=%s\n"):format(data.universalWord)
    for player in ivalues(Players) do
        local pn = ToEnumShortString(player)
        for profileName, value in pairs(data[pn]) do            
            strToWrite = strToWrite .. pn.."-"..profileName.. "="..value.word.."\n"
        end
    end
	if strToWrite ~= "" then
		local file= RageFileUtil.CreateRageFile()
		if file:Open(dataPath.."data.txt", 2) then
			file:Write(strToWrite)
			file:Close()
			file:destroy()
		else
			SCREENMAN:SystemMessage("Could not open '" .. dataPath.."data.txt" .. "' to write current playing info.")
		end
	end
end


function isNewDay()
    if duringRIGHTS() then
        wordleGame.date = date
        return true
    end
    if date ~= wordleGame.date then
        wordleGame.date = date
        return true
    else
        return false
    end
end
function getWordlePlayerData()
    local data
    local todaysPlayers
    if FILEMAN:DoesFileExist(dataPath.."data.txt") then
        data = readData(dataPath.."data.txt")
        wordleGame.date = data.date
    else
        SCREENMAN:SystemMessage("'" .. dataPath.."data.txt" .. "' does not exist")
    end

    newDay = isNewDay()
    -- If it's a new day clear the history of players with words
    if newDay then
        local file= RageFileUtil.CreateRageFile()

        if file:Open(dataPath..wordleGame.todaysPlayers, 2) then
            file:Write("")
            file:Close()
            file:destroy()
        else
            SCREENMAN:SystemMessage("Could not open '" .. dataPath..wordleGame.todaysPlayers .. "' to erase players today")
        end
        data.universalWord = getWordOfTheDay()
        data.P1.Guest.word = getWordOfTheDay()
        data.P2.Guest.word = getWordOfTheDay()

    end
    if FILEMAN:DoesFileExist(dataPath..wordleGame.todaysPlayers) then
        todaysPlayers = lua.ReadFile(dataPath..wordleGame.todaysPlayers)
    else
        SCREENMAN:SystemMessage("'" .. dataPath..wordleGame.todaysPlayers .. "' does not exist")
    end

    if not wordleGame.DiffWordPerSide and not wordleGame.DiffWordPerProfile then
        -- If not DiffWordSide and not DiffPerProfile
        -- then
        -- P1word = APPLE,  P2word = APPLE
        -- P3word = APPLE,  P3word = APPLE   
        -- Otherwise keep the same universal word currently present.

        --data[pn][wordleGame[pn].name].word = data.universalWord
        for player in ivalues(Players) do
            local profile = PROFILEMAN:GetProfile(player)
            local profileName = "Guest"
            local pn = ToEnumShortString(player)
            if PROFILEMAN:IsPersistentProfile(player) then
                if (profile and (profile:GetLastUsedHighScoreName() ~= "")) then
                    profileName = profile:GetLastUsedHighScoreName()
                end
            end
            wordleGame[pn].name = profileName
            if (not playedToday(profileName)) then
               if not data[ToEnumShortString(player)][profileName] then data[ToEnumShortString(player)][profileName] = {} end
                data[ToEnumShortString(player)][profileName].word = data.universalWord
                SCREENMAN:SystemMessage(data[ToEnumShortString(player)][profileName].word)

            end
        end
    elseif wordleGame.DiffWordPerSide and not wordleGame.DiffWordPerProfile then
        -- If DiffWordSide and not DiffPerProfile
        -- then
        -- P1word = APPLE,  P2word = JACKS
        -- P3word = APPLE,  P3word = JACKS

        for player in ivalues(Players) do
            local profile = PROFILEMAN:GetProfile(player)
            local profileName = "Guest"
            local pn = ToEnumShortString(player)
            if PROFILEMAN:IsPersistentProfile(player) then
                if (profile and (profile:GetLastUsedHighScoreName() ~= "")) then
                    profileName = profile:GetLastUsedHighScoreName()
                end
            end
            wordleGame[pn].name = profileName
            if (not playedToday(profileName)) then
               if not data[ToEnumShortString(player)][profileName] then data[ToEnumShortString(player)][profileName] = {} end
                data[ToEnumShortString(player)][profileName].word = data[ToEnumShortString(player)].Guest.word
            end
        -- Otherwise keep the same word on each side currently present.
        end

    elseif not wordleGame.DiffWordPerSide and wordleGame.DiffWordPerProfile then
        -- If not DiffWordSide and DiffPerProfile
        -- then
        -- P1word = APPLE,  P2word = APPLE
        -- P3word = BREAD,  P3word = BREAD

         -- Generate a new Universal Wordle if a new set of players are playing.
            data.universalWord = getWordOfTheDay()
            data.P1.Guest.word = data.universalWord
            data.P2.Guest.word = data.universalWord
            for player in ivalues(Players) do
                local profile = PROFILEMAN:GetProfile(player)
                local profileName = "Guest"
                local pn = ToEnumShortString(player)
                if PROFILEMAN:IsPersistentProfile(player) then
                    if (profile and (profile:GetLastUsedHighScoreName() ~= "")) then
                        profileName = profile:GetLastUsedHighScoreName()
                    end
                end
                wordleGame[pn].name = profileName
                if (not playedToday(profileName)) then
                    if not data[ToEnumShortString(player)][profileName] then data[ToEnumShortString(player)][profileName] = {} end
                    data[ToEnumShortString(player)][profileName].word = data.universalWord
                end
            end
        -- Otherwise keep the same word on each side currently present.


    elseif wordleGame.DiffWordPerSide and wordleGame.DiffWordPerProfile then
        -- If DiffWordSide and DiffPerProfile
        -- then
        -- P1word = APPLE,  P2word = JACKS
        -- P3word = BREAD,  P3word = AUDIO

         -- Generate a new Wordle for each new player playing
         for player in ivalues(Players) do
             local profile = PROFILEMAN:GetProfile(player)
             local profileName = "Guest"
             local pn = ToEnumShortString(player)
             if PROFILEMAN:IsPersistentProfile(player) then
                 if (profile and (profile:GetLastUsedHighScoreName() ~= "")) then
                     profileName = profile:GetLastUsedHighScoreName()
                 end
             end
             wordleGame[pn].name = profileName
             if (not playedToday(profileName)) then
                if not data[ToEnumShortString(player)][profileName] then data[ToEnumShortString(player)][profileName] = {} end
                 data[ToEnumShortString(player)][profileName].word = getWordOfTheDay()
             end
         end
     -- Otherwise keep the same word for the player on the present side
    end
    local strToWrite = todaysPlayers
    for player in ivalues(Players) do

        local pn = ToEnumShortString(player)
        if not wordleGame.DiffWordPerSide and not wordleGame.DiffWordPerProfile then    
            wordleGame[pn].word = data.universalWord            
        elseif wordleGame.DiffWordPerSide and not wordleGame.DiffWordPerProfile then
            wordleGame[pn].word = data[pn].Guest.word
        elseif not wordleGame.DiffWordPerSide and wordleGame.DiffWordPerProfile then
            wordleGame[pn].word = data[pn][wordleGame[pn].name].word

        elseif wordleGame.DiffWordPerSide and wordleGame.DiffWordPerProfile then
            wordleGame[pn].word = data[pn][wordleGame[pn].name].word
        end
        if (not playedToday(wordleGame[pn].name)) then
            strToWrite = strToWrite .. ("%s\n"):format(wordleGame[pn].name)
        end
    end
    local file= RageFileUtil.CreateRageFile()
    if file:Open(dataPath.."todaysPlayers.txt", 2) then
        file:Write(strToWrite)
        file:Close()
        file:destroy()
    else
        SCREENMAN:SystemMessage("Could not open '" .. dataPath.."todaysPlayers.txt" .. "' to write current playing info.")
    end
    SaveData(data)
end

function startWordle()
    if generateWordList() then
        getWordlePlayerData()
    else 
        SCREENMAN:SystemMessage("Insufficient words in your dictionary")
    end
end

local function isEditMode()
	local screen = SCREENMAN:GetTopScreen()
	if not screen then
	   return nil
	end
	local screen = SCREENMAN:GetTopScreen()	
	return (THEME:GetMetric(screen:GetName(), "Class") == "ScreenEdit")
end
---------------------------------------------------------------------------
-- Primary ActorFrame
local t = Def.ActorFrame {
    Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000)
	},
    Def.Quad{
        OnCommand=function(self)
            self:sleep(wordleGame.duration)
            self:queuecommand("Answer")
        end,
        AnswerCommand=function(self)
            MESSAGEMAN:Broadcast("ShowAnswer")
        end
    },
	InitCommand=function(self)
        startWordle()
		self:queuecommand("CaptureInput")
	end,
    OnCommand=function(self)
        if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
            P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
            P1:visible(false)
          end
          if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
              P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
              P2:visible(false)
          end
        if P2 then
            P2xpos=P2:GetX();
            P2ypos=P2:GetY();
        end
        if P1 then
            P1xpos=P1:GetX();
            P1ypos=P1:GetY();
        end	
    end,
	CaptureInputCommand=function(self)
		local topscreen = SCREENMAN:GetTopScreen()
        for name,layer in pairs(topscreen:GetChildren()) do
            if not (name=="SongBackground" or name=="SongForeground" or name=="Underlay" or name=="PlayerP1" or name=="PlayerP2") then
                layer:smooth(1.5):diffusealpha(0)
            end
            if (name=="SongBackground") then
               -- layer:visible(false)
            end
            if name == "In" then layer:visible(false) end
            if name == 'Underlay' then
                layer:visible(false)
                for player_index=1,2 do
                    local score = layer:GetChild('P' .. player_index .. 'Score')					
                    if score then score:visible(true):diffusealpha(1) end
                end
            end
        end
		for player in ivalues(Players) do
			local wheel = AlphabetWheels[ToEnumShortString(player)]
            
			if wheel then
				-- Sets the starting Char index to ("A")
				local StartingCharIndex = 3

				-- set_info_set() takes two arguments:
				--		a table of meaningful data to divvy up to wheel items
				--		the index of which wheel item we want to initially give focus to
				-- here, we are passing it all the possible characters,
				-- and either 2 ("ok") or 3 ("A") as the starting index
				AlphabetWheels[ToEnumShortString(player)]:set_info_set(PossibleCharacters, StartingCharIndex)
			end
		end

		-- actually attach the InputHandler function to our screen
		topscreen:AddInputCallback( LoadActor("InputHandler.lua", {self, AlphabetWheels, wordleGame}) )
	end,
	AttemptToFinishCommand=function(self)
		if not wordleGame.P1.EnteringWord and not wordleGame.P2.EnteringWord then
			self:playcommand("Finish")
		end
	end,
	ShowAnswerMessageCommand=function(self, param)

		-- -- if the timer runs out, check if either player hasn't finished entering his/her name
		-- -- if so, fade out that player's cursor and alphabetwheel and play the "start" sound
		for player in ivalues(Players) do
			local pn = ToEnumShortString(player)
			if wordleGame[pn].EnteringWord then
				-- hide this player's cursor
				-- hide this player's AlphabetWheel
				self:GetChild("AlphabetWheel_"..pn):queuecommand("Hide")

			end
		end

		self:playcommand("Finish")
	end,
	FinishCommand=function(self)
		-- store the highscore name for this game
		for player in ivalues(Players) do
			-- GAMESTATE:StoreRankingName(player, SL[ToEnumShortString(player)].HighScores.Name)

			-- -- if a profile is in use
			-- if PROFILEMAN:IsPersistentProfile(player) then
			-- 	-- update that profile's LastUsedHighScoreName attribute
			-- 	PROFILEMAN:GetProfile(player):SetLastUsedHighScoreName( SL[ToEnumShortString(player)].HighScores.Name )
			-- end
		end

		-- manually transition to the next screen (defined in Metrics)
		--SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
	end
}

-- Things that are constantly on the screen (fallback banner + masks)
t[#t+1] = Def.ActorFrame {

	--fallback banner
	LoadActor("StepManiaRaw.png")..{
		OnCommand=function(self) 
            self:xy(_screen.cx, 25.5):zoom(0.4) 
        end
	},

	Def.Quad{
		Name="LeftMask";
		InitCommand=function(self) self:horizalign(left) end,
		OnCommand=function(self) 
            self:xy(0, _screen.cy):zoomto(_screen.cx-272, _screen.h):MaskSource() 
            self:sleep(2*wordleGame.duration/3)
            self:queuecommand("Hurry")
        end,
        HurryCommand=function(self)
            local time = wordleGame.duration /3
            SCREENMAN:SystemMessage("Hurry up, ".. time .."s left!")
        end,
        ShowAnswerMessageCommand = function(self)
            if P1 then
                P1:visible(true)
                if not wordleGame.P1.solved then
                    if duringRIGHTS() then
                        GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions('ModsLevel_Song'):Stealth(0.8,999)
                        GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions('ModsLevel_Song'):Sudden(5, 999)
                        GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions('ModsLevel_Song'):Invert(-1,999)
                        self:sleep(16):queuecommand("FailP1")
                    else
                        self:queuecommand("FailP1")
                    end
                end
            end
            if P2 then
                P2:visible(true)
                if not wordleGame.P2.solved then
                    if duringRIGHTS() then
                        GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptions('ModsLevel_Song'):Stealth(0.8,999)
                        GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptions('ModsLevel_Song'):Sudden(5, 999)
                        GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptions('ModsLevel_Song'):Invert(-1,999)
                        self:sleep(16):queuecommand("FailP2")
                    else
                        self:queuecommand("FailP2")
                    end

                end
            end
            wordleGame.gameInProgress = false
        end,
        FailP1Command=function(self)
            STATSMAN:GetCurStageStats():GetPlayerStageStats(0):FailPlayer()
        end,
        FailP2Command=function(self)
            STATSMAN:GetCurStageStats():GetPlayerStageStats(1):FailPlayer()
        end
	},

	Def.Quad{
		Name="CenterMask",
		OnCommand=function(self) self:Center():zoomto(110, _screen.h):MaskSource() end,
        ShowAnswerMessageCommand = function(self)
            self:sleep(7):queuecommand("ClearWordle")
        end,
        ClearWordleCommand=function(self)
            local topscreen = SCREENMAN:GetTopScreen()
            for name,layer in pairs(topscreen:GetChildren()) do
                if (name=="SongBackground"  or name=="Underlay" or name=="PlayerP1" or name=="PlayerP2") then
                    layer:smooth(1.5):diffusealpha(1):visible(true)
                end
                if (name=="SongForeground") then
                    layer:visible(false)
                end
                if name == "In" then layer:visible(true) end
                if name == 'Underlay' then
                    layer:visible(true)
                    for player_index=1,2 do
                        local score = layer:GetChild('P' .. player_index .. 'Score')					
                        if score then score:visible(true):diffusealpha(1) end
                    end
                end
            end
        end
	},

	Def.Quad{
		Name="RightMask",
		InitCommand=function(self) self:horizalign(right) end,
		OnCommand=function(self) self:xy(_screen.w, _screen.cy):zoomto(_screen.cx-272, _screen.h):MaskSource() end
	}
}

for player in ivalues(Players) do
    local pn = ToEnumShortString(player)
    for y=1,wordleGame.Chances do 
        local LettersAndBoxes = Def.ActorFrame{
            Name=pn.."rowBoxes"..y,
            InitCommand=function(self) 
                self:visible(true)
            end,
            OnCommand=function(self)
                if pn == "P1" then
                    self:xy(SCREEN_WIDTH/20, SCREEN_HEIGHT/30):zoom(1.05)

                end
                if pn == "P2" then
                    self:xy(11.5*SCREEN_WIDTH/20, SCREEN_HEIGHT/30):zoom(1.05)
                end

            end,
            ShowAnswerMessageCommand=function(self)
               -- self:sleep(5):linear(5):diffusealpha(0)
            end,
            IncorrectCommand=function(self)
                self:linear(1):addrotationz(360)
            end,

        }

        for x=1,wordleGame.Letters do
            LettersAndBoxes[#LettersAndBoxes+1] = Def.ActorFrame {
                Name="letBox"..x,
                CheckCommand=function(self)
                    self:sleep(x/2):linear(0.75):addrotationx(360)
                end,
                ShowAnswerMessageCommand=function(self)
                    self:GetChild(pn.."Box"..x):diffuse(Color.White)
                    if (wordleGame[pn].solved) then
                        self:GetChild(pn.."Box"..x):sleep(x/1.2):diffuse(color("#538d4e"))
                    else
                        self:GetChild(pn.."Box"..x):sleep(x/1.2):diffuse(color("#cc4d27"))
                    end     
                   -- SCREENMAN:SystemMessage(wordleGame[pn])
                   if (wordleGame.revealWord or not wordleGame[pn].ExpertMode) then
                        self:GetChild(pn.."Letter"..x):sleep(x/1.2):settext(wordleGame[pn].word:sub(x,x))          
                   end
                 end,
                Def.Quad{
                    Name=pn.."Highlight"..x,
                    InitCommand=function(self)
                        local height = 40
                        local spacing = 20
                        self:diffuse(color("#bfbfbf")):zoomto(height, height*1.1):y((height+spacing-2)*y):x((2.5*spacing)*x)
                    end
                },
                Def.Quad{
                    Name=pn.."Box"..x,
                    InitCommand=function(self)
                        local height = 38
                        local spacing = 20
                        self:diffuse(color("#121213")):zoomto(height, height*1.1):y((height+spacing)*y):x((2.5*spacing)*x)
                    end,
                },
                LoadFont("Common Normal")..{
                    Name=pn.."Letter"..x,
                    InitCommand=function(self)
                        local height = 38
                        local spacing = 20
                        self:y((height+spacing)*y):x((2.5*spacing)*x)
                    end,
                    OnCommand=function(self)
                        self:settext("")
                    end,
                    CheckCommand=function(self)
                        local counter = 0;
                        local colors
                        -- If the letter entered matches the letter in the word at this index
                        if (self:GetText() == wordleGame[pn].word:sub(x,x)) then
                            colors = color("#538d4e")
                            self:GetParent():GetChild(pn.."Box"..x):sleep(x/1.1):diffuse(colors)

                        -- If the letter exists somewhere in the word
                        elseif (wordleGame[pn].word:match(self:GetText())) then
                            local restOfWord = wordleGame[pn].word
                            local amt = findMultipleOccurencesOfLetter(wordleGame[pn].word, self:GetText()) 
                            local currAmt = findMultipleOccurencesOfLetter(wordleGame[pn].guesses[wordleGame[pn].Line-1], self:GetText()) 
                            local matches = countMatches(wordleGame[pn].word, wordleGame[pn].guesses[wordleGame[pn].Line-1], self:GetText())
                           -- SM("amt: "..amt.." currAmt: "..currAmt.." matches: "..matches .. " word: "..wordleGame[pn].word .. " currentWord: "..wordleGame[pn].guesses[wordleGame[pn].Line-1])
                            if (matches == amt) then
                                colors = color("#3a3a3c")
                                self:GetParent():GetChild(pn.."Box"..x):sleep(x/1.1):diffuse(colors)
                            else
                                colors = color("#b59f3b")
                                self:GetParent():GetChild(pn.."Box"..x):sleep(x/1.1):diffuse(colors)
                            end             
                        -- If the letter is not found
                        else
                            colors = color("#3a3a3c")
                            self:GetParent():GetChild(pn.."Box"..x):sleep(x/1.1):diffuse(colors)
                        end

                        CharacterColors[AlphabetWheels[pn].name][self:GetText()] = colors

                    end,
                    ShowAnswerMessageCommand=function(self)
                        
                        --SCREENMAN:SystemMessage("ANSWERSS")
                       -- self:GetParent():GetChild(pn.."Box"..x):sleep(5):linear(5):diffusealpha(0)
                    end,
                    SetCommand=function(self)
                        self:settext(wordleGame[pn].lastEnteredLetter)
                    end,
                    UnsetCommand=function(self) 
                        self:settext("") 
                        --self:GetParent():GetChild(pn.."Box"..x):vibrate()
                    end,
    
                }
            }
        end
       
        -- add each LettersAndBoxes ActorFrame to the primary ActorFrame
        t[#t+1] = LettersAndBoxes
    end
end


for player in ivalues(Players) do
	local pn = ToEnumShortString(player)
	local x_offset = (player == PLAYER_1 and -186) or 264

    t[#t+1] = LoadActor("Cursor.png")..{
        Name="Cursor",
        InitCommand=function(self) self:diffuse(PlayerColor(Player)):zoom(0.5) end,
        OnCommand=function(self) 
            if pn == "P1" then
                self:visible( true ):x(_screen.cx - 226):y(_screen.cy+200) 
            end
            if pn == "P2" then
                self:visible( true ):x(_screen.cx + 223):y(_screen.cy+200) 
            end
        end,
        HideCommand=function(self) self:linear(0.25):diffusealpha(0) end
    }
	-- this returns an ActorFrame ( see: ./Scripts/Consensual-sick_wheel.lua )
	-- create_actors() takes five arguments
	--		a name
	--		the number of wheel actors to actually create onscreen
	--			note that this is NOT equal to how many items you want to be able to scroll through
	--			it is how many you want visually onscreen at a given moment
	--		a metatable defining a generic item in the wheel
	--		x position
	--		y position
	if wordleGame[pn].EnteringWord then
		t[#t+1] = AlphabetWheels[pn]:create_actors( "AlphabetWheel_"..pn, 7, alphabet_character_mt, _screen.cx + x_offset, _screen.cy+200)
	end
end

function findMultipleOccurencesOfLetter(word, letter)
    local found = word:match(letter)
    if found then
        return 1 + findMultipleOccurencesOfLetter(word:sub(word:find(letter)+1), letter)
    else
        return 0
    end
end

function findLocationOfLetter(word, letter, pn)
    local found = word:match(letter)
    if found then
        return 1 + findLocationOfLetter(word:sub(word:find(letter)+1), letter)
    else
        return 0
    end
end

-- WHEEL
-- WHEAT
-- E
-- 
function countMatches(word, currentWord, letter)
    local count = 0
    for i = 1, #word do
        if word:sub(i,i) == letter and currentWord:sub(i,i) == word:sub(i,i) then
            count = count + 1
        end
    end
    return count
end
-- ActorSounds
-- Sounds are from SL
t[#t+1] = LoadActor("Sounds/_change value")..{ Name="delete", SupportPan = true }
t[#t+1] = LoadActor("Sounds/Common start")..{ Name="enter", SupportPan = true }
t[#t+1] = LoadActor("Sounds/MusicWheel change")..{ Name="move", SupportPan = true }
t[#t+1] = LoadActor("Sounds/Common invalid")..{ Name="invalid", SupportPan = true }

--
return t
